
import gurobipy as gp

# Create a new model
m = gp.Model("woodshop")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tables")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chairs")

# Set objective
m.setObjective(1000*x + 300*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 2*y <= 25, "crafting_time")
m.addConstr(2*x + 1*y <= 15, "polishing_time")
m.addConstr(x >= 0, "tables_non_negative")
m.addConstr(y >= 0, "chairs_non_negative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of tables: {x.x}")
    print(f"Number of chairs: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

