
from gurobipy import *

# Create a new model
m = Model("Woodshop_Problem")

# Define variables
T = m.addVar(lb=0, vtype=GRB.INTEGER, name="Tables")
C = m.addVar(lb=0, vtype=GRB.INTEGER, name="Chairs")

# Set the objective function: Maximize profit
m.setObjective(1000*T + 300*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*T + 2*C <= 25, "Crafting_Hours")
m.addConstr(2*T + C <= 15, "Polishing_Hours")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tables to produce: {T.x}")
    print(f"Chairs to produce: {C.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
