
import gurobi

def woodshop_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(lb=0, name="Tables")
    C = model.addVar(lb=0, name="Chairs")

    # Objective function: Maximize profit
    model.setObjective(1000 * T + 300 * C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * T + 2 * C <= 25, name="CraftingHours")
    model.addConstr(2 * T + C <= 15, name="PolishingHours")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Tables: {T.varValue:.2f}")
        print(f"Chairs: {C.varValue:.2f}")
    else:
        print("No optimal solution found.")

# Run the model
woodshop_production()
