
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cafe Optimization")

# Create variables
u = m.addVar(lb=0, name="university_hours")
d = m.addVar(lb=0, name="downtown_hours")

# Set objective function
m.setObjective(400*u + 700*d, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*u + 40*d >= 900, "Cappuccinos")
m.addConstr(40*u + 70*d >= 700, "Lattes")
m.addConstr(60*u + 110*d >= 1400, "Regular Coffees")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"University Cafe Hours: {u.x}")
    print(f"Downtown Cafe Hours: {d.x}")
    print(f"Total Cost: ${m.objVal}")
else:
    print("Infeasible or unbounded solution.")

