
from gurobipy import *

# Create a new model
m = Model("Cafe_Optimization")

# Define the decision variables
U = m.addVar(lb=0, name="University_Cafe_Hours")
D = m.addVar(lb=0, name="Downtown_Cafe_Hours")

# Define the objective function: Minimize costs
m.setObjective(400*U + 700*D, GRB.MINIMIZE)

# Add constraints for production requirements
m.addConstr(30*U + 40*D >= 900, name="Cappuccino_Requirement")
m.addConstr(40*U + 70*D >= 700, name="Latte_Requirement")
m.addConstr(60*U + 110*D >= 1400, name="Regular_Coffee_Requirement")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"University Cafe should be run for {U.x} hours")
    print(f"Downtown Cafe should be run for {D.x} hours")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
