
import gurobi

def solve_cafe_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    university_hours = model.addVar(name="university_hours", lb=0, ub=None)
    downtown_hours = model.addVar(name="downtown_hours", lb=0, ub=None)

    # Define the objective function
    model.setObjective(400 * university_hours + 700 * downtown_hours, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(30 * university_hours + 40 * downtown_hours >= 900, name="cappuccino_production")
    model.addConstr(40 * university_hours + 70 * downtown_hours >= 700, name="latte_production")
    model.addConstr(60 * university_hours + 110 * downtown_hours >= 1400, name="regular_coffee_production")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible")
        return

    # Print the solution
    print(f"University cafe hours: {university_hours.varValue}")
    print(f"Downtown cafe hours: {downtown_hours.varValue}")
    print(f"Total cost: {model.objVal}")

solve_cafe_problem()
