
import gurobipy as gp

# Create a new model
m = gp.Model("curry_profit")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_curry")
y = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="goat_curry")

# Set objective
m.setObjective(5 * x + 7 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 2 * y <= 20, "tomatoes")
m.addConstr(2 * x + 3 * y <= 30, "curry_paste")
m.addConstr(3 * x + y <= 25, "water")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Chicken Curry Servings: {x.x}")
    print(f"Goat Curry Servings: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

