
from gurobipy import *

# Create a new model
model = Model("Curry_Production")

# Define the decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_curry")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="goat_curry")

# Set the objective function
model.setObjective(5*x + 7*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + 2*y <= 20, "tomatoes_constraint")
model.addConstr(2*x + 3*y <= 30, "curry_paste_constraint")
model.addConstr(3*x + y <= 25, "water_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken Curry: {x.x}")
    print(f"Goat Curry: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No optimal solution found")
