
import gurobipy as gp

# Create a new model
m = gp.Model("Curry Production")

# Define the decision variables
x = m.addVar(name="chicken_curry", lb=0, ub=None, obj=5)
y = m.addVar(name="goat_curry", lb=0, ub=None, obj=7)

# Define the constraints
m.addConstr(x + 2*y <= 20, name="tomatoes")
m.addConstr(2*x + 3*y <= 30, name="curry_paste")
m.addConstr(3*x + y <= 25, name="water")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GUROBI_OPTIMAL:
    print("Optimal solution found.")
    print(f"Chicken curry: {x.varValue}")
    print(f"Goat curry: {y.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
