
from gurobipy import *

# Create a model
m = Model("cake_pops")

# Define decision variables
x_s = m.addVar(lb=0, vtype=GRB.INTEGER, name="soft_cake_pops")
x_m = m.addVar(lb=0, vtype=GRB.INTEGER, name="smooth_cake_pops")
x_c = m.addVar(lb=0, vtype=GRB.INTEGER, name="crunchy_cake_pops")

# Objective function: Maximize profit
m.setObjective(4*x_s + 6*x_m + 5*x_c, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x_s + 15*x_m + 12*x_c <= 1000, name="batter_constraint")
m.addConstr(10*x_s + 15*x_m + 18*x_c <= 800, name="milk_constraint")

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective (Max Profit): ", m.objVal)
