
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(lb=0, name="Soft_Cake-pops")
    M = model.addVar(lb=0, name="Smooth_Cake-pops")
    C = model.addVar(lb=0, name="Crunchy_Cake-pops")

    # Objective function: Maximize profit
    model.setObjective(4*S + 6*M + 5*C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*S + 15*M + 12*C <= 1000, name="Batter_Constraint")
    model.addConstr(10*S + 15*M + 18*C <= 800, name="Milk_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Soft Cake-pops: {S.varValue}")
        print(f"Smooth Cake-pops: {M.varValue}")
        print(f"Crunchy Cake-pops: {C.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_bakery_problem()
