
from gurobipy import *

# Create a model
m = Model("Woodshop_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="dining_tables")
y = m.addVar(vtype=GRB.CONTINUOUS, name="bed_frames")

# Set the objective function
m.setObjective(300*x + 400*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 5*y <= 300, "oak_wood_constraint")
m.addConstr(5*x + 2*y <= 400, "mahogany_wood_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dining tables: {x.x}")
    print(f"Bed frames: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")

