
import gurobi as gp

# Create a new model
model = gp.Model("Woodshop_Optimization")

# Define the decision variables
x = model.addVar(name="dining_tables", lb=0, vtype=gp.GRB.CONTINUOUS)
y = model.addVar(name="bed_frames", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(300*x + 400*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 300, name="oak_wood_constraint")
model.addConstr(5*x + 2*y <= 400, name="mahogany_wood_constraint")

# Optimize the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Dining Tables: {x.varValue}")
    print(f"Bed Frames: {y.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
