
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("investment_problem")

    # Create variables
    x = m.addVar(vtype=GRB.CONTINUOUS, name="shoe_investment")
    y = m.addVar(vtype=GRB.CONTINUOUS, name="hat_investment")

    # Set objective function
    m.setObjective(0.07 * x + 0.06 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 20000, "total_investment")
    m.addConstr(x >= 4 * y, "investment_ratio")
    m.addConstr(x <= 15000, "max_shoe_investment")
    m.addConstr(x >= 0, "nonneg_x")  # Explicit non-negativity constraints
    m.addConstr(y >= 0, "nonneg_y")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment in shoe factory: ${x.x:.2f}")
        print(f"Optimal investment in hat factory: ${y.x:.2f}")
        print(f"Maximum earnings: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

