
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="shoe_factory_investment")
y = m.addVar(vtype=GRB.CONTINUOUS, name="hat_factory_investment")

# Set the objective function: Maximize earnings
m.setObjective(0.07*x + 0.06*y, GRB.MAXIMIZE)

# Define constraints
m.addConstr(x + y == 20000, "total_investment")
m.addConstr(x >= 4*y, "shoe_vs_hat_investment_ratio")
m.addConstr(x <= 15000, "max_shoe_factory_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shoe factory investment: ${x.x:.2f}")
    print(f"Hat factory investment: ${y.x:.2f}")
    print(f"Total earnings: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
