
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(name="Shoe_Factory_Investment", lb=0)
    H = model.addVar(name="Hat_Factory_Investment", lb=0)

    # Objective function: Maximize earnings
    model.setObjective(0.07 * S + 0.06 * H, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(S + H <= 20000, name="Total_Investment")
    model.addConstr(S >= 4 * H, name="Shoe_to_Hat_Min_Ratio")
    model.addConstr(S <= 15000, name="Shoe_Factory_Max_Investment")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in shoe factory: ${S.varValue:.2f}")
        print(f"Optimal investment in hat factory: ${H.varValue:.2f}")
        print(f"Maximized earnings: ${0.07 * S.varValue + 0.06 * H.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
