
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="t_shirts")  # Number of t-shirts
y = m.addVar(vtype=GRB.CONTINUOUS, name="hoodies")  # Number of hoodies

# Set objective function
m.setObjective(10 * x + 15 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * x + 2 * y <= 40, "design_constraint")
m.addConstr(2 * x + 3 * y <= 60, "printing_constraint")
m.addConstr(x >= 0, "t_shirts_non_negative")
m.addConstr(y >= 0, "hoodies_non_negative")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of T-shirts: {x.x}")
    print(f"Number of Hoodies: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

