
from gurobipy import *

# Create a new model
m = Model("Clothing_Collection")

# Define the decision variables
x = m.addVar(lb=0, name="t_shirts")  # Number of t-shirts
y = m.addVar(lb=0, name="hoodies")   # Number of hoodies

# Set the objective function: Maximize profit
m.setObjective(10*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 2*y <= 40, name="designing_time")  # Designing time constraint
m.addConstr(2*x + 3*y <= 60, name="printing_time")  # Printing time constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of t-shirts: {x.x}")
    print(f"Number of hoodies: {y.x}")
    print(f"Maximum profit: ${10*x.x + 15*y.x:.2f}")
else:
    print("No optimal solution found")

