
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    t = model.addVar(lb=0, name="t-shirts")
    h = model.addVar(lb=0, name="hoodies")

    # Define the objective function
    model.setObjective(10 * t + 15 * h, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(t + 2 * h <= 40, name="designing_time")
    model.addConstr(2 * t + 3 * h <= 60, name="printing_time")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible")
        return

    # Print the solution
    print("Optimal solution:")
    print(f"t-shirts: {t.varValue}")
    print(f"hoodies: {h.varValue}")
    print(f"Max profit: {model.objVal}")

solve_optimization_problem()
