
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("hot_dog_optimization")

# Create decision variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Regular hot dogs
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Premium hot dogs

# Set objective function
model.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 100, "demand_regular")
model.addConstr(x2 <= 250, "demand_premium")
model.addConstr(x1 + x2 <= 300, "total_production")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular hot dogs (x1): {x1.x}")
    print(f"Number of premium hot dogs (x2): {x2.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

