
from gurobipy import *

# Create a new model
m = Model("HotDogProduction")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="RegularHotDogs", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="PremiumHotDogs", lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "RegularDemand")
m.addConstr(x2 <= 250, "PremiumDemand")
m.addConstr(x1 + x2 <= 300, "TotalProduction")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Regular Hot-Dogs: {x1.x}")
    print(f"Premium Hot-Dogs: {x2.x}")
    print(f"Maximum Profit: ${3*x1.x + 5*x2.x:.2f}")
else:
    print("No optimal solution found.")
