
import gurobi

def solve_hot_dog_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, ub=100, name="regular_hot_dogs")
    x2 = model.addVar(lb=0, ub=250, name="premium_hot_dogs")

    # Objective function: Maximize profit
    model.setObjective(3 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Production capacity constraint
    model.addConstraint(x1 + x2 <= 300, name="production_capacity")

    # Demand constraints are inherently handled by setting ub for x1 and x2

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Produce {x1.x} regular hot dogs and {x2.x} premium hot dogs.")
        print(f"Maximum profit: ${3 * x1.x + 5 * x2.x}")
    else:
        print("The model is infeasible.")

solve_hot_dog_problem()
