
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PancakeMix")

# Create variables
x = m.addVar(lb=0, name="MixA")
y = m.addVar(lb=0, name="MixB")

# Set objective function
m.setObjective(20*x + 25*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x + 0.15*y >= 10, "SugarConstraint")
m.addConstr(0.60*x + 0.50*y >= 50, "FlourConstraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Mix A (kg): {x.x}")
    print(f"Mix B (kg): {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

