
from gurobipy import *

# Create a new model
m = Model("Pancake_Mix")

# Define the decision variables
x_A = m.addVar(vtype=GRB.CONTINUOUS, name="Mix_A", lb=0)
x_B = m.addVar(vtype=GRB.CONTINUOUS, name="Mix_B", lb=0)

# Set the objective function: minimize cost
m.setObjective(20*x_A + 25*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x_A + 0.15*x_B >= 10, "Sugar_Constraint")
m.addConstr(0.60*x_A + 0.50*x_B >= 50, "Flour_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x_A.x} kg of Mix A")
    print(f"Buy {x_B.x} kg of Mix B")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")

