
import gurobi

def solve_pancake_mix_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x_A = m.addVar(name="Mix_A", lb=0)  # Amount of Mix A
    x_B = m.addVar(name="Mix_B", lb=0)  # Amount of Mix B

    # Objective function: Minimize cost
    m.setObjective(20 * x_A + 25 * x_B, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(0.10 * x_A + 0.15 * x_B >= 10, name="Sugar_Requirement")
    m.addConstr(0.60 * x_A + 0.50 * x_B >= 50, name="Flour_Requirement")

    # Solve the problem
    m.optimize()

    # Check if the model is optimized
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of Mix A: {x_A.varValue} kg")
        print(f"Optimal amount of Mix B: {x_B.varValue} kg")
        print(f"Minimum cost: ${m.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_pancake_mix_problem()
