
import gurobipy as gp

# Create a new model
model = gp.Model("Vacuum_Repair")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="shop_vacuums")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="home_vacuums")

# Set objective function
model.setObjective(35*x + 20*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1*x + 0.5*y <= 300, "disassembly_constraint")
model.addConstr(2*x + 1*y <= 400, "repair_constraint")
model.addConstr(x >= 0, "shop_nonneg")
model.addConstr(y >= 0, "home_nonneg")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of shop vacuums to repair: {x.x}")
    print(f"Number of home vacuums to repair: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

