
from gurobipy import *

# Create a model
m = Model("Vacuum_Repair")

# Define the decision variables
x = m.addVar(name="home_vacuums", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="shop_vacuums", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function to maximize profit
m.setObjective(20*x + 35*y, GRB.MAXIMIZE)

# Add constraints for disassembly and repair time
m.addConstr(0.5*x + y <= 300, name="disassembly_time")
m.addConstr(x + 2*y <= 400, name="repair_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${20*x.x + 35*y.x:.2f}")
else:
    print("Model is infeasible")
