
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="home_vacuums")
y = model.addVar(lb=0, name="shop_vacuums")

# Define the objective function
model.setObjective(20 * x + 35 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(0.5 * x + y <= 300, name="disassembly_time")
model.addConstr(x + 2 * y <= 400, name="repair_time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Home vacuums to repair: {x.varValue}")
    print(f"Shop vacuums to repair: {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
