
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bus_seating")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
y = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective
m.setObjective(40*x + 20*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "total_seats")
m.addConstr(x >= 10, "min_premium")
m.addConstr(y >= 5*x, "regular_preference")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Premium seats: {x.x}")
    print(f"Regular seats: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

