
from gurobipy import *

# Create a model
m = Model("Tour_Bus_Profit")

# Define decision variables
x_p = m.addVar(vtype=GRB.CONTINUOUS, name="premium_seats")
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="regular_seats")

# Objective function: Maximize profit
m.setObjective(40*x_p + 20*x_r, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_p + x_r <= 100, "total_seats")
m.addConstr(x_p >= 10, "min_premium_seats")
m.addConstr(x_r >= 5*x_p, "regular_to_premium_ratio")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Sell {x_p.x} premium seats and {x_r.x} regular seats.")
else:
    print("No optimal solution found.")

