
import gurobipy as gp

# Create a new model
m = gp.Model("Tour_Bus_Problem")

# Define variables
P = m.addVar(name="Premium_Seats", lb=0, ub=100, vtype=gp.GRB.INTEGER)
R = m.addVar(name="Regular_Seats", lb=0, ub=100, vtype=gp.GRB.INTEGER)

# Objective function: maximize profit
m.setObjective(40 * P + 20 * R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(P + R <= 100, name="Total_Seats")
m.addConstr(P >= 10, name="Min_Premium_Seats")
m.addConstr(R >= 5 * P, name="Preference_Regular")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Premium Seats = {P.varValue}, Regular Seats = {R.varValue}")
    print(f"Max Profit: ${40 * P.varValue + 20 * R.varValue}")
else:
    print("The model is infeasible")
