
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cereal_mix")

# Create variables
x = m.addVar(lb=0, name="cereal_A")
y = m.addVar(lb=0, name="cereal_B")

# Set objective function
m.setObjective(0.45 * x + 0.55 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(25 * x + 20 * y >= 400, "iron_req")
m.addConstr(30 * x + 40 * y >= 450, "fiber_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal servings of cereal A: {x.x}")
    print(f"Optimal servings of cereal B: {y.x}")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

