
from gurobipy import *

# Create a new model
m = Model("Cereal_Mixing_Problem")

# Define variables
x_A = m.addVar(name="cereal_A", vtype=GRB.CONTINUOUS, lb=0)
x_B = m.addVar(name="cereal_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(0.45*x_A + 0.55*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(25*x_A + 20*x_B >= 400, name="iron_requirement")
m.addConstr(30*x_A + 40*x_B >= 450, name="fiber_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of Cereal A: {x_A.x}")
    print(f"Servings of Cereal B: {x_B.x}")
    print(f"Total Cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
