
import gurobi as gp

# Create a new model
m = gp.Model("Cereal_Mixing")

# Define variables
x = m.addVar(name="cereal_A", lb=0)  # Servings of cereal A
y = m.addVar(name="cereal_B", lb=0)  # Servings of cereal B

# Objective: Minimize cost
m.setObjective(0.45 * x + 0.55 * y, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(25 * x + 20 * y >= 400, name="iron_requirement")
m.addConstr(30 * x + 40 * y >= 450, name="fiber_requirement")

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal servings of cereal A: {x.varValue}")
    print(f"Optimal servings of cereal B: {y.varValue}")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("The problem is infeasible.")
