
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Tropical_Fruit_Optimization")

# Create decision variables
g = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="guavas")
m = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mangos")

# Set objective function
model.setObjective(300*g + 500*m, GRB.MAXIMIZE)

# Add constraints
model.addConstr(g + m <= 100, "land_constraint")
model.addConstr(m >= g, "mango_preference")
model.addConstr(m <= 2*g, "workload_constraint")
model.addConstr(g >= 20, "min_guavas")
model.addConstr(m >= 40, "min_mangos")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {g.x} acres of guavas")
    print(f"Plant {m.x} acres of mangos")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

