
from gurobipy import *

# Create a new model
m = Model("Tropical_Farmer")

# Define the decision variables
G = m.addVar(name='Guavas', vtype=GRB.CONTINUOUS, lb=0)
M = m.addVar(name='Mangos', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(300*G + 500*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(G + M <= 100, name='Total_Land')
m.addConstr(M <= 2*G, name='Mangos_vs_Guavas')
m.addConstr(G >= 20, name='Min_Guavas')
m.addConstr(M >= 40, name='Min_Mangos')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Grow {G.x} acres of guavas and {M.x} acres of mangos.")
else:
    print("No optimal solution found.")
