
import gurobipy as gp

# Create a new model
m = gp.Model("TropicalFarmer")

# Define variables
G = m.addVar(lb=20, name="Guavas")  # At least 20 acres of guavas
M = m.addVar(lb=40, name="Mangos")  # At least 40 acres of mangos

# Objective function: Maximize profit
m.setObjective(300*G + 500*M, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(G + M <= 100, name="Total_Acres")  # Total acres constraint
m.addConstr(M <= 2*G, name="Mangos_vs_Guavas")  # Mangos vs guavas constraint

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of Guavas: {G.varValue}")
    print(f"Optimal acres of Mangos: {M.varValue}")
    print(f"Max Profit: ${300*G.varValue + 500*M.varValue}")
else:
    print("The model is infeasible")
