
import gurobipy as gp

# Create a new model
model = gp.Model("fast_food_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="wraps")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls")

# Set the objective function
model.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 800, "rice_constraint")
model.addConstr(2*x + 3*y <= 700, "fish_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of wraps to sell: {x.x}")
    print(f"Number of bowls to sell: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

