
from gurobipy import *

# Create a new model
m = Model("FastFoodProfit")

# Define the decision variables
W = m.addVar(vtype=GRB.CONTINUOUS, name="wraps", lb=0)
B = m.addVar(vtype=GRB.CONTINUOUS, name="bowls", lb=0)

# Define the objective function
m.setObjective(5*W + 7*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*W + 5*B <= 800, "rice_limit")
m.addConstr(2*W + 3*B <= 700, "fish_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Wraps to sell: {W.x}")
    print(f"Bowls to sell: {B.x}")
    print(f"Maximum profit: ${5*W.x + 7*B.x:.2f}")
else:
    print("No optimal solution found")
