
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
w = m.addVar(lb=0, name="wraps")
b = m.addVar(lb=0, name="bowls")

# Define the objective function
m.setObjective(5 * w + 7 * b, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3 * w + 5 * b <= 800, name="rice_constraint")
m.addConstr(2 * w + 3 * b <= 700, name="fish_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal solution: {w.varName} = {w.x}, {b.varName} = {b.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
