
import gurobipy as gp

# Create a new model
model = gp.Model("FoodTruckOptimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="tacos")
y = model.addVar(vtype=gp.GRB.INTEGER, name="burritos")

# Set objective function
model.setObjective(3*x + 6*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 50, "min_tacos")
model.addConstr(y >= 30, "min_burritos")
model.addConstr(x <= 80, "max_tacos")
model.addConstr(y <= 50, "max_burritos")
model.addConstr(x + y <= 100, "max_total")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of tacos to sell: {x.x}")
    print(f"Number of burritos to sell: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

