
from gurobipy import *

# Create a new model
m = Model("Food_Truck_Profit")

# Define the decision variables
tacos = m.addVar(lb=50, ub=80, vtype=GRB.INTEGER, name="tacos")
burritos = m.addVar(lb=30, ub=50, vtype=GRB.INTEGER, name="burritos")

# Define the objective function: Maximize profit
m.setObjective(3*tacos + 6*burritos, GRB.MAXIMIZE)

# Add the constraint for the total number of items
m.addConstr(tacos + burritos <= 100, "total_items")

# Optimize the model
m.optimize()

# Print out the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tacos to sell: {tacos.x}")
    print(f"Number of burritos to sell: {burritos.x}")
    print(f"Total profit: ${3*tacos.x + 6*burritos.x:.2f}")
else:
    print("No optimal solution found")
