
import gurobi

def food_truck_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables with their bounds
    x = model.addVar(lb=50, ub=80, name="tacos")  # At least 50, at most 80 tacos
    y = model.addVar(lb=30, ub=50, name="burritos")  # At least 30, at most 50 burritos

    # Add the constraint for the total number of items
    model.addConstr(x + y <= 100, name="total_items")

    # Define the objective function
    model.setObjective(3*x + 6*y, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        # Get the optimized values
        tacos_to_sell = x.varValue
        burritos_to_sell = y.varValue
        max_profit = model.objVal

        print(f"Optimal Solution: Sell {tacos_to_sell} tacos and {burritos_to_sell} burritos.")
        print(f"Maximum Profit: ${max_profit:.2f}")
    else:
        print("The model is infeasible.")

# Run the optimization
food_truck_optimization()
