
import gurobipy as gp

# Create a new model
m = gp.Model("landscaping")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="y")
z = m.addVar(vtype=gp.GRB.CONTINUOUS, name="z")


# Set objective
m.setObjective(200*x + 175*y + 225*z, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 5*y + 12*z <= 1200, "rock")
m.addConstr(7*x + 12*y + 4*z <= 700, "mulch")
m.addConstr(15*x + 10*y + 12*z <= 2000, "grass")

# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Type A layouts (x): {x.x}")
    print(f"Number of Type B layouts (y): {y.x}")
    print(f"Number of Type C layouts (z): {z.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

