
from gurobipy import *

# Create a model
m = Model("Landscaping Optimization")

# Define decision variables
xA = m.addVar(name="Type_A", vtype=GRB.INTEGER, lb=0)
xB = m.addVar(name="Type_B", vtype=GRB.INTEGER, lb=0)
xC = m.addVar(name="Type_C", vtype=GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(200 * xA + 175 * xB + 225 * xC, GRB.MAXIMIZE)

# Constraints
# Rock constraint
m.addConstr(10 * xA + 5 * xB + 12 * xC <= 1200, name="Rock_Constraint")

# Mulch constraint
m.addConstr(7 * xA + 12 * xB + 4 * xC <= 700, name="Mulch_Constraint")

# Grass constraint
m.addConstr(15 * xA + 10 * xB + 12 * xC <= 2000, name="Grass_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Type A layouts: {xA.x}")
    print(f"Type B layouts: {xB.x}")
    print(f"Type C layouts: {xC.x}")
    print(f"Maximum profit: ${200 * xA.x + 175 * xB.x + 225 * xC.x:.2f}")
else:
    print("No optimal solution found.")
