
import gurobipy as gp

# Create a new model
model = gp.Model("Landscaper_Problem")

# Define the decision variables
x_A = model.addVar(lb=0, name="x_A")  # number of type A layouts
x_B = model.addVar(lb=0, name="x_B")  # number of type B layouts
x_C = model.addVar(lb=0, name="x_C")  # number of type C layouts

# Define the objective function
model.setObjective(200 * x_A + 175 * x_B + 225 * x_C, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * x_A + 5 * x_B + 12 * x_C <= 1200, name="rock_constraint")
model.addConstr(7 * x_A + 12 * x_B + 4 * x_C <= 700, name="mulch_constraint")
model.addConstr(15 * x_A + 10 * x_B + 12 * x_C <= 2000, name="grass_constraint")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Type A layouts: {x_A.varValue}")
    print(f"Type B layouts: {x_B.varValue}")
    print(f"Type C layouts: {x_C.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible or unbounded.")
