
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vehicle_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cars")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bikes")

# Set objective function
m.setObjective(5000 * x + 1000 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x + 1 * y <= 400, "engineering_time")
m.addConstr(30 * x + 30 * y <= 1000, "steel")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Cars to Produce: {x.x}")
    print(f"Number of Bikes to Produce: {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

