
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x_c = m.addVar(vtype=GRB.CONTINUOUS, name="cars_produced")
x_b = m.addVar(vtype=GRB.CONTINUOUS, name="bikes_produced")

# Set the objective function: Maximize profit
m.setObjective(5000*x_c + 1000*x_b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x_c + 30*x_b <= 1000, "steel_availability")
m.addConstr(3*x_c + x_b <= 400, "engineering_time_availability")
m.addConstr(x_c >= 0, "non_negativity_cars")
m.addConstr(x_b >= 0, "non_negativity_bikes")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x_c.x} cars and {x_b.x} bikes.")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found. The model is likely infeasible or unbounded.")
