
import gurobi

def vehicle_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(name="cars", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    B = model.addVar(name="bikes", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(5000*C + 1000*B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*C + B <= 400, name="engineering_time")
    model.addConstr(30*C + 30*B <= 1000, name="steel_availability")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Cars produced: {C.x:.2f}")
        print(f"Bikes produced: {B.x:.2f}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    vehicle_production_problem()
