
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("FastFoodOptimization")

# Create decision variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fries")

# Set objective function
model.setObjective(1.5 * x1 + x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 110, "demand_cheeseburgers")
model.addConstr(x2 <= 80, "demand_fries")
model.addConstr(x1 + x2 <= 150, "capacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Number of Cheeseburgers: {x1.x}")
    print(f"Number of Fries: {x2.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

